#include <iostream>
#include <vector>
#include <iomanip>
#include <algorithm>
#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>
#include <random>

using namespace std;
using namespace __gnu_pbds;

mt19937 rnd(459);

typedef long long ll;
typedef tree<int, null_type, less<int>, rb_tree_tag, tree_order_statistics_node_update> indexed_set;;

#define all(x) x.begin(), x.end()
#ifdef DUDE
#define debug(x) cout << #x << ":\t" << x << endl
#else
#define debug(x) ;
#endif // DUDE

template<typename T>
istream& operator >> (istream& in, vector<T>& vec) {
    for (T& e :vec) {
        in >> e;
    }
    return in;
}

template<typename T>
ostream& operator << (ostream& out, const vector<T>& vec) {
    char end_char = '\n';
    if (typeid(T) == typeid(int) || typeid(T) == typeid(ll))
        end_char = ' ';
    for (const T& e :vec)
        out << e << end_char;
    return out;
}

template<typename T>
bool mini(T& a, const T& b) {
    if (a > b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
bool maxi(T& a, const T& b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

/*
 *
 */

bool check(ll x, ll y, ll d) {
    if (d > x)
        return false;
    return ((y - (x - d)) % d == 0);
}

ll fast_solution(ll x, ll y) {
    if (x == y)
        return 0;
    ll c = y - x;
    ll d = 1;
    ll a = 1;
    //debug(c);
    while (d * d <= c) {
        if (c % d != 0) {
            ++d;
            continue;
        }
        if (check(x, y, d))
            maxi(a, d);
        if (check(x, y, c / d)) {
            maxi(a, c / d);
            break;
        }
        ++d;
    }
    return x - a;
}

ll slow_solution(ll x, ll y) {
    ll t = 0;
    while ((y - t) % (x - t)) {
        ++t;
    }
    return t;
}

void stress() {
    //freopen("input.txt", "w", stdout);
    while (true) {
        ll x = rnd() % 100000 + 1, y = rnd() % 100000 + 1;
        if (x > y)
            swap(x, y);
        ll res1 = fast_solution(x, y);
        ll res2 = slow_solution(x, y);
        if (res1 == res2)
            continue;
        cout << "1\n" << x << ' ' << y << endl;
        cout << res1 << ' ' << res2 << endl;
        exit(0);
    }
}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);

    //stress();
    #ifdef DUDE
        freopen("input.txt", "r", stdin);
        freopen("output.txt", "w", stdout);
    #endif
    int test;
    cin >> test;
    while (test--) {
        ll x, y;
        cin >> x >> y;
        cout << fast_solution(x, y) << '\n';
    }

}
